/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config.utils;

import com.queplix.core.jxb.entity.types.SqlSType;

/**
 * <p>Contains entity field meta data</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:16 $
 */

public class EntityFieldInfoVO
        implements java.io.Serializable {

    private String dbcolumnName;
    private int columnSize;
    private boolean isNullable;
    private SqlSType sqlType;

    /**
     * Constructor.
     *
     * @param dbcolumnName unique name
     * @param columnSize   column size
     * @param isNullable   can field store NULLs
     */
    public EntityFieldInfoVO(String dbcolumnName,
                             int columnSize,
                             boolean isNullable) {

        this.dbcolumnName = dbcolumnName;
        this.columnSize = columnSize;
        this.isNullable = isNullable;
    }

    //
    // Getters.
    //

    public String getDbcolumnName() {
        return dbcolumnName;
    }

    public int getColumnSize() {
        return columnSize;
    }

    public boolean isIsNullable() {
        return isNullable;
    }

    public SqlSType getSqlType() {
        return sqlType;
    }

    //
    // Setters.
    //

    public void setSqlType(SqlSType sqlType) {
        this.sqlType = sqlType;
    }

    // Hash code.
    public int hashCode() {
        return dbcolumnName.hashCode();
    }

    // Equals.
    public boolean equals(Object o) {
        if(o == null || !(o instanceof EntityFieldInfoVO)) {
            return false;
        } else {
            return ((EntityFieldInfoVO) o).dbcolumnName.equals(dbcolumnName);
        }
    }

}