/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

/**
 * <p>EQL dataset response object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:19 $
 */

public class EQLDRes
        extends EQLERes {

    // ------------------------------------------------------- variables

    private EQLReqDataset reqDataset;

    // ------------------------------------------------------- constructor

    public EQLDRes(EQLReqDataset reqDataset) {
        super(reqDataset.getDatasetEntity());
        this.reqDataset = reqDataset;
    }

    // ------------------------------------------------------- public methods

    // Get base Req Dataset.

    public EQLReqDataset getReqDataset() {
        return reqDataset;
    }

    // Check if dataset changed.
    // .. if we modify or deleted a dataset - record is changed
    public boolean isChanged() {
        for(int i = 0; i < size(); i++) {
            if(getRecord(i).isChanged() || getRecord(i).doDelete()) {
                return true;
            }
        }
        return false;
    }

    // Hash code.
    public int hashCode() {
        return reqDataset.hashCode();
    }

    // Equals.
    public boolean equals(Object o) {
        if(o == null) {
            return false;
        }

        if(o == this) {
            return true;
        }

        if(o instanceof EQLDRes) {
            EQLDRes dRes = (EQLDRes) o;
            return reqDataset.equals(dRes.reqDataset);
        }

        return false;
    }

    // To string.
    public String toString() {
        return "dataset response: " + reqDataset;
    }
}
