/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import com.queplix.core.jxb.entity.Dataset;
import com.queplix.core.jxb.entity.Efield;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * <p>EQL request Meta-Data object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqMetaData
        implements java.io.Serializable {

    // ----------------------------------------------------- variables

    // Set of Eifled id attributes for lazy loading
    private Set lazyLoadFields;
    // Set of Eifled id attributes for lazy loading
    private Set lazyLoadDatasets;
    // Flag indicates that system should ignore all dataset during loading
    private boolean ignoreAllDatasets;
    // Meta data map
    private Map map;

    // ----------------------------------------------------- public methods

    /**
     * Add entity field into lazy load set
     *
     * @param field Efield object
     */
    public void addLazyLoadField(Efield field) {
        __getLazyLoadFields().add(field.getId());
    }

    /**
     * Checks if field is lazy loaded
     *
     * @param field Efield object
     * @return boolean
     */
    public boolean isLazyLoadField(Efield field) {
        if(lazyLoadFields == null) {
            return false;
        } else {
            return __getLazyLoadFields().contains(field.getId());
        }
    }

    /**
     * Add entity dataset into lazy load set
     *
     * @param dataset Dataset object
     */
    public void addLazyLoadDataset(Dataset dataset) {
        __getLazyLoadDatasets().add(dataset.getId());
    }

    /**
     * Checks if dataset is lazy loaded
     *
     * @param dataset Dataset object
     * @return boolean
     */
    public boolean isLazyLoadDataset(Dataset dataset) {
        if(lazyLoadDatasets == null) {
            return false;
        } else {
            return __getLazyLoadDatasets().contains(dataset.getId());
        }
    }

    /**
     * Set flag to ignore all datasets
     *
     * @param ignoreAllDatasets flag
     */
    public void setIgnoreAllDatasets(boolean ignoreAllDatasets) {
        this.ignoreAllDatasets = ignoreAllDatasets;
    }

    /**
     * Get flag to ignore all datasets (true - ignore)
     *
     * @return boolean
     */
    public boolean isIgnoreAllDatasets() {
        return ignoreAllDatasets;
    }

    /**
     * Add custom parameter
     *
     * @param name  parameter name
     * @param value parameter value
     */
    public void setParam(String name, Object value) {
        __getMap().put(name, value);
    }

    /**
     * Delete custom parameter
     *
     * @param name parameter name
     */
    public void delParam(String name) {
        if(map != null) {
            __getMap().remove(name);
        }
    }

    /**
     * Get custom parameter value
     *
     * @param name parameter name
     * @return parameter value
     */
    public Object getParam(String name) {
        if(map == null) {
            return null;
        } else {
            return __getMap().get(name);
        }
    }

    //
    // Get string
    //
    public String toString() {
        return "lazyLoadFields=" + lazyLoadFields + "\n" +
                "lazyLoadDatasets=" + lazyLoadDatasets + "\n" +
                "ignoreAllDatasets=" + ignoreAllDatasets + "\n" +
                "map=" + map;
    }

    // ----------------------------------------------------- private methods

    private synchronized Set __getLazyLoadFields() {
        if(lazyLoadFields == null) {
            lazyLoadFields = new HashSet();
        }
        return lazyLoadFields;
    }

    private synchronized Set __getLazyLoadDatasets() {
        if(lazyLoadDatasets == null) {
            lazyLoadDatasets = new HashSet();
        }
        return lazyLoadDatasets;
    }

    private synchronized Map __getMap() {
        if(map == null) {
            map = new HashMap();
        }
        return map;
    }
}
