/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql;

import com.queplix.core.modules.eql.ops.NoneOp;

/**
 * <p>EQL Request Select Clause Attribute object</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:20 $
 */

public class EQLReqSelectAttr
        implements java.io.Serializable {

    private EQLReqField reqField;
    private EQLReqOp reqOp;
    private EQLReqSelectAttr listFieldAttr;

    public EQLReqSelectAttr(EQLReqField reqField, EQLReqOp reqOp) {
        this.reqField = reqField;
        this.reqOp = reqOp;
    }

    public void setListFieldSelectAttr(EQLReqSelectAttr listFieldAttr) {
        this.listFieldAttr = listFieldAttr;
    }

    public EQLReqOp getReqOp() {
        return reqOp;
    }

    public EQLReqField getReqField() {
        return reqField;
    }

    public String getId() {
        return reqField.getField().getId();
    }

    public EQLReqSelectAttr getListFieldSelectAttr() {
        return listFieldAttr;
    }

    /**
     * Get constant value
     *
     * @return EQLObject or NULL
     */
    public EQLObject getConstant() {
        if(reqOp.size() == 1) {
            EQLReqSubOp subOp = reqOp.getSubOp(0);
            if(subOp instanceof NoneOp && subOp
                    .getMember() instanceof EQLObject) {
                return (EQLObject) subOp.getMember();
            }
        }
        return null;
    }

    /**
     * Is attribute constant?
     *
     * @return boolean
     */
    public boolean isConstant() {
        return (getConstant() != null);
    }

}
