/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.ejb;

import com.queplix.core.modules.config.ejb.CaptionManagerLocal;
import com.queplix.core.modules.config.ejb.CaptionManagerLocalHome;
import com.queplix.core.modules.config.ejb.CustomConfigManagerLocal;
import com.queplix.core.modules.config.ejb.CustomConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocal;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocalHome;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocal;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.ejb.AbstractSessionEJB;

/**
 * <p>Abstract session EJB supports EQL</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:22 $
 */

public abstract class AbstractEQLSupportedEJB
        extends AbstractSessionEJB {

    // --------------------- NEW FEATURES ----------------------

    // get EntityViewConfigManager local interface

    public EntityViewConfigManagerLocal getEntityViewConfigManager() {
        return (EntityViewConfigManagerLocal) getLocalObject(
                JNDINames.EntityViewConfigManager,
                EntityViewConfigManagerLocalHome.class);
    }

    // get FocusConfigManagerLocal local interface
    public FocusConfigManagerLocal getFocusConfigManager() {
        return (FocusConfigManagerLocal) getLocalObject(
                JNDINames.FocusConfigManager,
                FocusConfigManagerLocalHome.class);
    }

    // get CustomConfigManager local interface
    public CustomConfigManagerLocal getCustomConfigManager() {
        return (CustomConfigManagerLocal) getLocalObject(
                JNDINames.CustomConfigManager,
                CustomConfigManagerLocalHome.class);
    }

    // get Caption Manager Local interface
    public CaptionManagerLocal getCaptionManagerLocal() {
        return (CaptionManagerLocal) getLocalObject(
                JNDINames.CaptionManager,
                CaptionManagerLocalHome.class);
    }

    // get NextKey Local interface
    public NextKeyLocal getNextKeyLocal() {
        return (NextKeyLocal) getLocalObject(
                JNDINames.NextKey,
                NextKeyLocalHome.class);
    }

    // get EQLManager local interface
    public EQLManagerLocal getEQLManager() {
        return (EQLManagerLocal) getLocalObject(JNDINames.EQLManager,
                EQLManagerLocalHome.class);
    }

    // get UserPropertyManager local interface
    public UserPropertyManagerLocal getUserPropertyManager() {
        return (UserPropertyManagerLocal) getLocalObject(
                JNDINames.UserPropertyManager,
                UserPropertyManagerLocalHome.class);
    }

}