/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.funcs;

import com.queplix.core.modules.eql.EQLNumberObject;
import com.queplix.core.modules.eql.EQLReqFuncExecutable;
import com.queplix.core.modules.eql.EQLReqOp;
import com.queplix.core.modules.eql.EQLReqSubOpMember;
import com.queplix.core.modules.eql.EQLReqSubOpMemberFunc;
import com.queplix.core.modules.eql.EQLStringObject;
import com.queplix.core.modules.eql.ejb.NextKeyLocal;
import com.queplix.core.modules.eql.ejb.NextKeyLocalHome;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.error.EQLFunctionParseException;
import com.queplix.core.utils.JNDINames;

/**
 * <p>Next Key Function Implementation</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:25 $
 */

public final class NextKeyFunc
        extends EQLReqSubOpMemberFunc implements EQLReqFuncExecutable {

    /*
     * No javadoc
     * @see EQLReqFuncExecutable#execute
     */
    public EQLReqSubOpMember execute()
            throws EQLException {

        EQLReqOp reqOp = getParameter(0);
        if(reqOp == null) {
            throw new EQLFunctionParseException(this);
        }

        String dbobject;
        try {
            EQLStringObject subOpMember = (EQLStringObject) reqOp.getSubOp(0)
                    .getMember();
            dbobject = subOpMember.getValue();
        } catch (Exception ex) {
            throw new EQLFunctionParseException(this, ex);
        }

        // get next key
        long next_key = getNextKeyLocal().next(dbobject);
        return new EQLNumberObject(new Long(next_key));
    }

    // get NextKey Local interface
    private NextKeyLocal getNextKeyLocal() {
        return (NextKeyLocal) eqlInt.getSession().getCOM().getLocalObject(
                JNDINames.NextKey,
                NextKeyLocalHome.class);
    }
}
