/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eql.update;

import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eql.EQLERes;
import com.queplix.core.modules.eql.EQLResRecord;
import com.queplix.core.modules.eql.EQLSession;

import java.io.Serializable;

/**
 * Value object class for entity updates.
 *
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:33 $
 */

public class EntityUpdateObject
        implements Serializable {

    // ================================================================== Fields

    private EQLSession session;
    private EQLERes res;
    private EQLResRecord resRecord;

    // ========================================================== Initialization

    /**
     * Creates a new VO.
     *
     * @param session   EQL session
     * @param res       EQLERes response object
     * @param resRecord EQL response record
     */
    public EntityUpdateObject(EQLSession session,
                              EQLERes res,
                              EQLResRecord resRecord) {
        this.session = session;
        this.res = res;
        this.resRecord = resRecord;
    }

    // ========================================================== Access methods

    public Entity getEntity() {
        return res.getEntity();
    }

    public EQLSession getSession() {
        return session;
    }

    public EQLERes getResponse() {
        return res;
    }

    public EQLResRecord getRecord() {
        return resRecord;
    }

    public String toString() {
        return "[entity = " + getEntity().getName() + ", record = " + resRecord
                + "]";
    }

}
