/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.actions;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.config.ejb.CustomConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.FocusConfigManagerLocal;
import com.queplix.core.modules.config.ejb.UserPropertyManagerLocal;
import com.queplix.core.modules.config.jxb.Custom;
import com.queplix.core.modules.config.jxb.CustomField;
import com.queplix.core.modules.config.jxb.Form;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;

/**
 * <p>EQL EXT Action Context Class</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:36 $
 */

public final class ActionContext
        implements java.io.Serializable {

    // user security session
    private LogonSession sc;
    // EntityViewConfigManager local interface
    private EntityViewConfigManagerLocal evcmLocal;
    // FocusConfigManagerLocal local interface
    private FocusConfigManagerLocal fcmLocal;
    // CustomConfigManager local interface
    private CustomConfigManagerLocal ccmLocal;
    // EQLManager local interface
    private EQLManagerLocal eqlmLocal;
    // UserPropertyManager local interface
    private UserPropertyManagerLocal upmLocal;

    // ------------------ PUBLIC METHODS -----------------------

    public ActionContext(LogonSession sc,
                         EntityViewConfigManagerLocal evcmLocal,
                         FocusConfigManagerLocal fcmLocal,
                         CustomConfigManagerLocal ccmLocal,
                         EQLManagerLocal eqlmLocal,
                         UserPropertyManagerLocal upmLocal) {

        this.sc = sc;
        this.evcmLocal = evcmLocal;
        this.fcmLocal = fcmLocal;
        this.ccmLocal = ccmLocal;
        this.eqlmLocal = eqlmLocal;
        this.upmLocal = upmLocal;
    }

    /**
     * Get LogonSession
     *
     * @return LogonSession object
     */
    public final LogonSession getSC() {
        if(sc == null) {
            throw new IllegalStateException();
        }

        return sc;
    }

    /**
     * Get EQL manager local interface
     *
     * @return EQLManagerLocal object
     */
    public final EQLManagerLocal getEQLManager() {
        if(eqlmLocal == null) {
            throw new IllegalStateException();
        }

        return eqlmLocal;
    }

    /**
     * Get UserProperty manager local interface
     *
     * @return UserPropertyManagerLocal object
     */
    public final UserPropertyManagerLocal getUserPropertyManager() {
        if(upmLocal == null) {
            throw new IllegalStateException();
        }

        return upmLocal;
    }

    /**
     * Get Entity object
     *
     * @param entityName Entity name attribute
     * @return Entity
     */
    public final Entity getEntityViewConfig(String entityName) {
        if(evcmLocal == null) {
            throw new IllegalStateException();
        }

        return evcmLocal.getEntityViewConfig(entityName);
    }

    /**
     * Get Form object
     *
     * @param formName Form name attribute
     * @return Form
     */
    public final Form getFormConfig(String formName) {
        if(fcmLocal == null) {
            throw new IllegalStateException();
        }

        return fcmLocal.getForm(formName);
    }

    /**
     * Get CustomField object and cache it
     *
     * @param entityName Entity name attribute
     * @return CustomField object
     */
    public final Custom getCustom(String entityName) {
        if(ccmLocal == null || sc == null) {
            throw new IllegalStateException();
        }

        return ccmLocal.getLocalizedCustomConfig(sc.getUser().getLangID(),
                entityName);
    }

    /**
     * Get CustomField object and cache it
     *
     * @param entityName Entity name attribute
     * @param fieldName  Efield name attribute
     * @return CustomField object
     */
    public final CustomField getCustomField(String entityName,
                                            String fieldName) {
        if(ccmLocal == null || sc == null) {
            throw new IllegalStateException();
        }

        return ccmLocal.getLocalizedCustomField(sc.getUser().getLangID(),
                entityName, fieldName);
    }

}
