/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.transforms.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.SecurityHelper;
import com.queplix.core.integrator.security.User;
import com.queplix.core.jxb.entity.Efield;
import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.eqlext.error.EfieldTransformException;
import com.queplix.core.modules.eqlext.transforms.EfieldTransform;
import com.queplix.core.modules.eqlext.utils.ExtDateParser;
import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.SystemHelper;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * <p>Default Date transform class</p>
 *
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:39 $
 */

public class DateTransform
        extends EfieldTransform {

    /*
     * No javadoc
     * @see EfieldTransform#toObject
     */
    public Object toObject(LogonSession ls, Entity entity, Efield field,
                           String s)
            throws EfieldTransformException {

        User user = ls.getUser();
        String datePattern = user.getDatePattern();
        boolean isDatePosFirst = user.isDatePositionFirst();
        Locale userLocale = SecurityHelper.getJavaLocale(user.getCountryID(),
                user.getLangID());
        TimeZone userTZ = SecurityHelper.getJavaTimezone(user.getTimeZoneID());

        try {
            long ms = ExtDateParser.parseDate(s,
                    isDatePosFirst,
                    userLocale,
                    userTZ,
                    datePattern,
                    null);

            Date d = new Date(ms);

            // reset hours, mins, secs to 0
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);

            if(userTZ.getRawOffset() < SystemHelper.SYSTEM_TIMEZONE
                    .getRawOffset()) {
                // add one day
                cal.add(Calendar.DATE, 1);
            }
            cal.set(Calendar.HOUR_OF_DAY, 0);
            cal.set(Calendar.MINUTE, 0);
            cal.set(Calendar.SECOND, 0);
            d = cal.getTime();

            return d;

        } catch (ParseException ex) {
            throw new EfieldTransformException(ex.getMessage(), ex);
        }
    }

    /*
     * No javadoc
     * @see EfieldTransform#toString
     */
    public String toString(LogonSession ls, Entity entity, Efield field,
                           Object o) {

        User user = ls.getUser();
        String datePattern = user.getDatePattern();
        Locale userLocale = SecurityHelper.getJavaLocale(user.getCountryID(),
                user.getLangID());
        TimeZone userTZ = SecurityHelper.getJavaTimezone(user.getTimeZoneID());

        Date sysDate = (Date) o;
        Date userDate = new Date(DateHelper.toUser(sysDate.getTime(), userTZ));

        return DateHelper.formatDate(userDate, datePattern, null, userLocale);
    }
}
