/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.eqlext.utils.images;

/**
 * <p>Keep regexp structure</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:44 $
 */

public class ReStruct
        implements java.io.Serializable {

    private final String regexp;
    private final int name_pos;
    private final int subfolder_pos;
    private final int content_pos;

    // Constructor.
    public ReStruct(String regexp, int name_pos, int subfolder_pos,
                    int content_pos) {
        this.regexp = regexp;
        this.name_pos = name_pos;
        this.subfolder_pos = subfolder_pos;
        this.content_pos = content_pos;
    }

    // Getters.

    public String getRegexp() {
        return regexp;
    }

    public int getNamePos() {
        return name_pos;
    }

    public int getSubfolderPos() {
        return subfolder_pos;
    }

    public int getContentPos() {
        return content_pos;
    }

    // hash code...
    public int hashCode() {
        return regexp.hashCode();
    }

    // equals...
    public boolean euals(Object o) {
        if(o == null || !(o instanceof ReStruct)) {
            return false;
        }
        return regexp.equals(((ReStruct) o).regexp);
    }

    // to string...
    public String toString() {
        return "regexp=" + regexp +
                " name_pos=" + name_pos +
                " subfolder_pos=" + subfolder_pos +
                " content_pos=" + content_pos;
    }
}
