/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.inbox;

import java.util.Date;

/**
 * Interface represents the Mail Account.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface Account
        extends java.io.Serializable {

    // ----------------------------------------------------- getters

    long getAccountID();

    String getProviderName();

    String getServer();

    Integer getPort();

    String getFolderName();

    String getName();

    String getPassword();

    Integer getDelayInMinutes();

    Long getMaxMessageSize();

    Long getMaxMailboxSize();

    Boolean getValidFlag();

    Boolean getDeleteMailFlag();

    Boolean getMarkEmailAsSeenFlag();

    Date getLastReceiveDate();

    Long getDefaultOwner();

    Long getDefaultWorkgroup();

    String getMessageUID();

    String getMessageDigest();

    // ----------------------------------------------------- setters

    void setValidFlag(Boolean b);

    void setLastReceiveDate(Date d, String messageUID, String messageDigest);

    void setLastMessageID(String messageUID, String messageDigest);

    void setNextCheckDate(Date d);
}
