/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.inbox.utils;

import javax.mail.Message;
import javax.mail.MessagingException;

/**
 * A table of data representing a found Inbox massages.
 * To build table it uses <code>MessageFilter</code> - message filter.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2006/07/10 11:07:28 $
 */

public interface ResultSet
        extends java.io.Serializable {

    /**
     * Sets MessageFilter.
     *
     * @param filter MessageFilter
     */
    void setMessageFilter(MessageFilter filter);

    /**
     * Get next Message.
     *
     * @return Message
     * @throws MessagingException
     */
    Message next()
            throws MessagingException;

    /**
     * Get next Message.
     *
     * @return Message
     * @throws MessagingException
     */
    Message nextByAccount(long accountId)
            throws MessagingException;

    /**
     * Closes result set.
     */
    void close();
}
