/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.jeo.JEObject;

import java.util.Date;

/**
 * Account object.
 *
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public interface AccountObject extends JEObject {

    public Long getPkey();

    public Long getOwner_id();

    public Long getWorkgroup_id();

    public String getAccount_name();

    public Long getAccount_provider();

    public String getEmail_server();

    public String getEmail_server_port();

    public String getEmail_server_folder();

    public String getEmail_password();

    public String getLogin_name();

    public Date getLastreceive_date();

    public Long getMax_mail_size();

    public Long getMax_inbox_size();

    public Long getDelay();

    public Date getNext_check_date();

    public char[] getNotes();

    public Long getAutoreply_id();

    public Long getCreated_by();

    public Date getCreated_date();

    public Integer getDelete_email_flag();

    public Integer getUnread_email_flag();

    public Integer getUnread_outemail_flag();

    public Integer getActive_acc();

    public Integer getValid_acc();

    public String getReply_email();

    public void setPkey(Long l);

    public void setOwner_id(Long l);

    public void setWorkgroup_id(Long l);

    public void setAccount_name(String s);

    public void setAccount_provider(Long l);

    public void setEmail_server(String s);

    public void setEmail_server_port(String s);

    public void setEmail_server_folder(String s);

    public void setEmail_password(String s);

    public void setLogin_name(String s);

    public void setLastreceive_date(Date d);

    public void setMax_mail_size(Long l);

    public void setMax_inbox_size(Long l);

    public void setDelay(Long l);

    public void setNext_check_date(Date l);

    public void setNotes(char[] ch);

    public void setAutoreply_id(Long l);

    public void setCreated_by(Long l);

    public void setCreated_date(Date d);

    public void setDelete_email_flag(Integer i);

    public void setUnread_email_flag(Integer i);

    public void setUnread_outemail_flag(Integer i);

    public void setActive_acc(Integer i);

    public void setValid_acc(Integer i);

    public void setReply_email(String s);

}
