/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * Report request JEO handler.
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $
 */
public class ReportObjectHandler
        extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */

    public String getEntityName() {
        return "report";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return ReportObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the report request by ID.
     *
     * @param jeoManager JEOManager EJB local interface
     * @param ls         LogonSession object with security data
     * @param id         report ID to search by
     * @return report JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByID(JEOManagerLocal jeoManager,
                                             LogonSession ls, long id)
            throws EQLException {

        String eql = "select report.* where report.report_id = " + id;
        List hndList = jeoManager.select(ls, ReportObjectHandler.class, eql);
        return (hndList != null) ? (JEObjectHandler) hndList.get(0):null;
    }

}
