/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.mail;

import com.queplix.core.utils.StringHelper;

/**
 * Mail data value object.
 *
 * @author [DAG] Dmitry Gaponenko
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:49 $
 */

public class MailMessage
        implements java.io.Serializable {

    // --------------------------------------------------------------- Constants

    /**
     * Text content type.
     */
    public static final int BODYTYPE_TEXT = 0;

    /**
     * HTML content type.
     */
    public static final int BODYTYPE_HTML = 1;

    // --------------------------------------------------------------- Fields

    /**
     * 'From' address (for external messages).
     */
    private MailAddress from;

    /**
     * 'To' addresses (for external messages).
     */
    private MailAddress[] to;

    /**
     * 'Cc' addresses (for external messages).
     */
    private MailAddress[] cc;

    /**
     * 'Bcc' addresses (for external messages).
     */
    private MailAddress[] bcc;

    /**
     * Message subject.
     */
    private String subject;

    /**
     * Message body.
     */
    private String body;

    /**
     * Message content type.
     */
    private int bodyType = BODYTYPE_TEXT;

    /**
     * Unique process ID (It helps us to get temporary attachments).
     */
    private Long processId;

    // --------------------------------------------------------------- Constructors

    public MailMessage(MailAddress[] to, String subject, String body) {
        setTo(to);
        setSubject(subject);
        setBody(body);
    }

    public MailMessage() {
        //To change body of created methods use File | Settings | File Templates.
    }

    // --------------------------------------------------------------- Getters/Setters

    public MailAddress[] getTo() {
        return to;
    }

    public MailAddress[] getCc() {
        return cc;
    }

    public MailAddress[] getBcc() {
        return bcc;
    }

    public String getSubject() {
        return subject;
    }

    public String getBody() {
        return body;
    }

    public int getBodyType() {
        return bodyType;
    }

    public MailAddress getFrom() {
        return from;
    }

    public Long getProcessId() {
        return processId;
    }

    public void setTo(MailAddress[] to) {
        this.to = to;
    }

    public void setCc(MailAddress[] cc) {
        this.cc = cc;
    }

    public void setBcc(MailAddress[] bcc) {
        this.bcc = bcc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
        this.bodyType = StringHelper.isHTML(body) ? BODYTYPE_HTML:BODYTYPE_TEXT;
    }

    public void setFrom(MailAddress from) {
        this.from = from;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

} // end of class
