/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.tools.config;

import com.queplix.core.modules.config.actions.CustomInstallationAction;
import com.queplix.core.tools.AbstractTool;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Tool wich starts CustomInstallation action execution</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:14 $
 */

public class CustomInstallationTool
        extends AbstractTool {

    //
    // Call action
    //
    public void callAction(Map params)
            throws Exception {
        callAction(new CustomInstallationAction(), params);
    }

    //
    // Main method
    //
    public static void main(String[] args) {

        String customdir = null;
        String i18ndir = null;

        // parse params
        for(int i = 0; i < args.length; i++) {
            String s = args[i];
            if(s.equals("-customdir")) {
                customdir = args[++i];
            } else if(s.equals("-i18ndir")) {
                i18ndir = args[++i];
            }
        }

        // fill params
        Map params = new HashMap();
        params.put("customdir", customdir);
        params.put("i18ndir", i18ndir);

        // start action
        try {
            new CustomInstallationTool().callAction(params);

        } catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("USAGE: java CustomInstallationTool " +
                    "-customdir CUSTOM_DIR -i18ndir I18N_DIR");
        }
    }
}
