/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.tools.config;

import com.queplix.core.modules.config.actions.FormInstallationAction;
import com.queplix.core.tools.AbstractTool;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Tool wich starts FormInstallation action execution</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:15 $
 */

public class FormInstallationTool
        extends AbstractTool {

    //
    // Call action
    //
    public void callAction(Map params)
            throws Exception {
        callAction(new FormInstallationAction(), params);
    }

    //
    // Main method
    //
    public static void main(String[] args) {

        String focusdir = null;
        String logdir = null;

        // parse params
        for(int i = 0; i < args.length; i++) {
            String s = args[i];

            if(s.equals("-focusdir")) {
                focusdir = args[++i];
            } else if(s.equals("-logdir")) {
                try {
                    logdir = args[++i];
                } catch (ArrayIndexOutOfBoundsException ex) {
                }
            }
        }

        // fill params
        Map params = new HashMap();
        params.put("focusdir", focusdir);
        params.put("logdir", logdir);

        // start action
        try {
            new FormInstallationTool().callAction(params);

        } catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("USAGE: java FormInstallationTool " +
                    "-focusdir FOCUS_DIR [-logdir LOG_DIR]");
        }
    }
}
