/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.tools.config;

import com.queplix.core.tools.AbstractTool;

import javax.naming.InitialContext;

/**
 * <p>Simple test tool (only for debugging)</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:15 $
 */

public class TestTool
        extends AbstractTool {

    //
    // Test
    //
    public void testJNDI()
            throws Exception {

        InitialContext ic = new InitialContext();
        System.out.println(
                "Initial context environment: " + ic.getEnvironment());
        System.out.println("\n");

        System.out.println(
                "Enumerates the names bound in the named context, along with the objects bound to them:");
        printBindings(ic);
    }

    //
    // Test
    //
    public void testJNDI(String jndiName)
            throws Exception {

        InitialContext ic = new InitialContext();
        System.out.println(
                "Initial context environment: " + ic.getEnvironment());
        System.out.println("\n");

        System.out.println("Try to find object: " + jndiName);
        Object o = ic.lookup(jndiName);
        System.out.println("Found object: " + o);
    }

    //
    // Main method
    //
    public static void main(String[] args) {

        String jndiName = null;
        if(args.length > 0) {
            jndiName = args[0];
        }

        // start testing
        try {
            if(jndiName != null) {
                new TestTool().testJNDI(jndiName);
            } else {
                new TestTool().testJNDI();
            }

            System.out.println("The end !!!");

        } catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("USAGE: java TestTool [JNDI name]");
        }
    }
}
