/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql;

import com.queplix.core.error.GenericSystemException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * <p>Retrive information from field info table</p>
 *
 * @author Baranov Andrey [ALB]
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:20 $
 */

public final class FieldInfoHelper {
    private static Class CLASS = FieldInfoHelper.class;

    private static String GET_LABEL_SQL =
            "SELECT ENUM_LABEL FROM QW_FIELDINFO " +
                    "WHERE TABLE_NAME=? AND COLUMN_NAME=? AND ENUM_VALUE=?";

    private static SqlWrapper sqlWrapper = SqlWrapperFactory.getSqlWrapper();

    /**
     * Retrive <code>ENUM_LABEL</code> field from table <code>QW_FIELDINFO</code>
     *
     * @param con        database connection
     * @param tableName  table name
     * @param columnName column name
     * @param value      column value
     * @return <code>ENUM_LABEL</code> field
     */
    public static String getLabel(Connection con, String tableName,
                                  String columnName, int value) {
        String label = null;
        PreparedStatement ps = null;

        try {
            ps = sqlWrapper.doPreparedStatement(con, GET_LABEL_SQL);
            ps.setString(1, tableName.toLowerCase());
            ps.setString(2, columnName.toLowerCase());
            ps.setInt(3, value);

            ResultSet rs = sqlWrapper.executeQuery(ps);
            if(rs.next()) {
                label = rs.getString(1);
            }

        } catch (SQLException ex) {
            throw new GenericSystemException(
                    "SQL exception: " + ex.getMessage(), ex);

        } finally {
            sqlWrapper.closeConnection(ps);
        }

        return label;
    }

    /**
     * Default constructor
     */
    private FieldInfoHelper() {
    }
}