/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.error;

import java.sql.SQLException;

/**
 * SQL exception subclass.
 * Is thrown when INSERT confilcts with a unique index constraint.
 * <p/>
 * <p/>
 * Provides more specific info, than <code>SQLException</code>:
 * <ul>
 * <li>table name,</li>
 * <li>violated constraint name.</li>
 * </ul>
 * <p/>
 *
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:21 $
 */
public class SQLIndexConflictException extends SQLException {

    // ================================================================== Fields

    private String table;
    private String constraint;

    // ========================================================== Initialization

    public SQLIndexConflictException(String message, String table,
                                     String constraint) {
        super(message);
        this.table = table;
        this.constraint = constraint;
    }

    // ========================================================== Access methods

    public String getTable() {
        return table;
    }

    public String getConstraint() {
        return constraint;
    }

}
