/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.parser;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * SQL data parser interface.
 *
 * @author [ALB] Baranov L. Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:22 $
 */
public interface SqlTypeParser
        extends java.io.Serializable {

    /**
     * Retrives object from <code>ResultSet<code>.
     *
     * @param rs SQL <code>ResultSet</code> object
     * @param i  column number
     * @return object from <code>ResultSet</code>
     * @throws SQLException
     */
    public Object getObject(ResultSet rs, int i)
            throws SQLException;

    /**
     * Retrives object from <code>CallableStatement<code>.
     *
     * @param cs SQL <code>CallableStatement</code> object
     * @param i  column number
     * @return object from <code>CallableStatement</code>
     * @throws SQLException
     */
    public Object getObject(CallableStatement cs, int i)
            throws SQLException;

    /**
     * Sets the object into the <code>PreparedStement<code>.
     *
     * @param stat PreparedStatement object
     * @param pos  position to set
     * @param data object
     * @throws SQLException
     */
    public void setObject(PreparedStatement stat, int pos, Object data)
            throws SQLException;

}