/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.sql.vendor.jboss;

import com.queplix.core.utils.sql.parser.BinaryParser;
import com.queplix.core.utils.sql.parser.MemoParser;
import com.queplix.core.utils.sql.vendor.oracle.BinaryParserOracleImpl;
import com.queplix.core.utils.sql.vendor.oracle.MemoParserOracleImpl;
import com.queplix.core.utils.sql.vendor.oracle.SqlWrapperOracleImpl;

/**
 * JBOSS SQL wrapper implementation.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2005/03/22 08:05:49 $
 */
public class SqlWrapperJBOSSImpl
        extends SqlWrapperOracleImpl {

    private final MemoParserOracleImpl memoParser
            = new MemoParserOracleJBOSSImpl();
    private final BinaryParserOracleImpl binaryParser
            = new BinaryParserOracleJBOSSImpl();

    /* (non-Javadoc)
     * @see SqlWrapper#getMemoParser()
     */
    public MemoParser getMemoParser() {
        return memoParser;
    }

    /* (non-Javadoc)
     * @see SqlWrapper#getBinaryParser()
     */
    public BinaryParser getBinaryParser() {
        return binaryParser;
    }

}
