/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.xml;

import org.w3c.dom.Node;

import java.io.Writer;

/**
 * <p>Interface for xml binding implementation</p>
 *
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:25 $
 */

public interface XMLBinding {

    Object xmlToJava(Class cl, Node node);

    void javaToXml(Object o, Writer out);

    void javaToXml(Object o, Node node);

    Object getAttribute(Object obj, String name, Class cl);

    void copyAttributes(Object src, Object dest, Class cl);

    public void copyAttributes(Object src, Object dest, Class srcCl,
                               Class destCl);

    void copyUndefinedAttributes(Object src, Object dest, Class cl);

    Object clone(Object src, Class cl);

}