/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */


package com.queplix.core.client.app;

import java.util.HashMap;
import java.util.Map;

/**
 * Gets and decodes query string from GWT frame.
 * @author dmitry.antonov
 */
public class RequestParamsDecoder {
    
    private final Map paramsMap = new HashMap();
    
    private static native String getQueryString () /*-{
        return $wnd.location.search;
    }-*/;
    
    private void setRequestParams() {
        String queryString = getQueryString();
        if (queryString != null && queryString.length() > 1) {
            String qs = queryString.substring(1);
            String[] kvPairs = qs.split("&");
            for (int i = 0; i < kvPairs.length; i++) {
                String[] kv = kvPairs[i].split("=");
                if (kv.length > 1) {
                    paramsMap.put(kv[0], unescape(kv[1]));
                }
                else {
                    paramsMap.put(kv[0], "");
                }
            }
        }
    }

    public String getParam(String paramName) {
        return (String) paramsMap.get(paramName);
    }
    
    public Map getParamsMap() {
        return paramsMap;
    }
    
    private native String unescape (String val) /*-{
        return unescape(val);
    }-*/;
    
    /** Creates a new instance of RequestParamsDecoder */
    public RequestParamsDecoder() {
        setRequestParams();
    }
}
