/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.rpc;

import com.google.gwt.user.client.rpc.RemoteService;
import com.queplix.core.client.app.vo.LoginRequestObject;
import com.queplix.core.client.app.vo.LoginResult;

/**
 * Login Service.
 *
 * @author Sultan Tezadov
 * @since 4 Oct 2006
 */
public interface LoginService extends RemoteService {
    /**
     * Pass null as role when the role is not known yet.
     */
    public LoginResult login(LoginRequestObject lro) throws RPCException;

    public void logout() throws RPCException;

    public void keepSessionAlive() throws RPCException;
}
