/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * This is panel, that has same behaiour as GWT Absolute panel, but doesn't use "absolute" position when set widget position,
 * because in FF it doesn't works.
 *
 * @author Sergey Kozmin
 */
public class CrossBrowsersAbsolutePanel extends AbsolutePanel {
    public void setWidgetPosition(Widget w, int left, int top) {
        Element h = w.getElement();
        DOM.setStyleAttribute(h, "position", "relative");
        DOM.setStyleAttribute(h, "left", left + "px");
        DOM.setStyleAttribute(h, "top", top + "px");
    }
}
