/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListenerAdapter;
import com.google.gwt.user.client.ui.Widget;

/**
 * Link icon button.
 *
 * @author Sultan Tezadov
 * @since 18 Jan 2007
 */
public class LinkIconButton extends IconButton {
    private static final String CSS = "linkIconButton";
    private HorizontalPanel panel;
    private Label link;

    public LinkIconButton(final ButtonData buttonState) {
        super(buttonState, false); // don't init widget
        panel = new HorizontalPanel();
        link = new Label(buttonState.getCaption());
        link.addStyleName(CSS);
        final String linkStyle = buttonState.getCaptionStyle();
        if(linkStyle != null) {
            link.addStyleName(linkStyle);
            if(buttonState.hasCaptionHoverStyle()) {
                link.addMouseListener(new MouseListenerAdapter() {
                    public void onMouseEnter(Widget sender) {
                        link.addStyleName(buttonState.getCaptionHoverStyle());
                    }

                    public void onMouseLeave(Widget sender) {
                        link.removeStyleName(
                                buttonState.getCaptionHoverStyle());
                    }
                });
            }
        }
        panel.add(icon);
        panel.add(new Label(" ")); // white space
        panel.add(link);
        link.addClickListener(this);
        initWidget(panel);
    }

}
