/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.event.EventListener;

/**
 * Popup Menu.
 *
 * @author Sultan Tezadov
 * @since 29 Nov 2006
 */
public class MenuPopup extends LabelButtonSet
        implements ClickListener, EventListener {

    public static interface Events {
        Event MENUPOPUP_SHOW_REQUEST = new Event();
    }

    private static final String CSS_STYLE = "menuPopup";
    private PopupPanel popup;
    private Widget attachTo;
    private boolean ableToShow = true;

    public MenuPopup() {
        this(null);
    }

    public MenuPopup(Widget attachTo) {
        super(false);
        this.attachTo = attachTo;
        if(attachTo != null) {
            if(attachTo instanceof SourcesClickEvents) {
                ((SourcesClickEvents) attachTo).addClickListener(this);
            }
        }
        getEventSource().addEventListener(this);
        setStyleName(CSS_STYLE);
    }

    public void setAbleToShow(boolean ableToShow) {
        this.ableToShow = ableToShow;
    }

    public void onClick(Widget sender) {
        if(ableToShow) {
            show();
        } else {
            getEventSource().fireEvent(Events.MENUPOPUP_SHOW_REQUEST);
        }
    }

    public void show() {
        if(getButtonsCount() == 0) {
            return;
        }
        int left = 0;
        int top = 0;
        if(attachTo != null) {
            left = attachTo.getAbsoluteLeft();
            top = attachTo.getAbsoluteTop() + attachTo.getOffsetHeight();
        }
        show(left, top);
    }

    public void show(int left, int top) {
        PopupPanel popup = getPopup();
        popup.show();
        if(left + popup.getOffsetWidth() > Window.getClientWidth()) {
            popup.setPopupPosition(
                    left + attachTo.getOffsetWidth() - popup.getOffsetWidth(),
                    top);
        } else {
            popup.setPopupPosition(left, top);
        }
    }

    private PopupPanel getPopup() {
        if(popup == null) {
            popup = new PopupPanel(true);
            popup.add(this);
        }
        return popup;
    }

    public void onEvent(Event event, Widget sender) {
        hide(); // hide on item click
    }

    public void hide() {
        getPopup().hide();
    }

}
