/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

/*
 * NonModalPopupListenerCollection.java
 *
 * @since 26.10.2006 .
 * @author Vasily Mikhailitchenko
 *
 */

package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.PopupListener;

import java.util.Iterator;
import java.util.Vector;

/**
 * A helper class for implementers of the SourcesPopupEvents interface.
 * This subclass of Vector assumes that all objects added to it will be of type
 * {@link com.google.gwt.user.client.ui.PopupListener}.
 */
public class NonModalPopupListenerCollection extends Vector {

    /**
     * Fires a popup closed event to all listeners.
     *
     * @param sender     the widget sending the event.
     * @param autoClosed <code>true</code> if the popup was automatically
     *                   closed; <code>false</code> if it was closed programmatically.
     */
    public void firePopupClosed(NonModalPopup sender, boolean autoClosed) {
        for(Iterator it = iterator(); it.hasNext();) {
            PopupListener listener = (PopupListener) it.next();
//      listener.onPopupClosed(sender, autoClosed);
        }
    }
}  
