/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * This class contais some JSNI methods for windows.
 *
 * @author Aliaksandr Melnik
 * @since 6 Dec 2006
 */
public class WindowHelper {
    /**
     * Calls print for the wnd window.
     */
    public static native void printWindow(JavaScriptObject wnd) /*-{
        wnd.print();
    }-*/;

    /**
     * Opens new window and returns referance to it.
     */
    public static native JavaScriptObject openWindow(String url) /*-{
        return $wnd.open(url, '_blank');
    }-*/;

    /**
     * Navigates to the specified URL.
     */
    public static native void navigate(String url) /*-{
        if ($wnd.location.href) { // FireFox
            $wnd.location.href = url;
        } else if ($wnd.navigate) { // Internet Explorer
            $wnd.navigate(url);
        }
    }-*/;

    public static void setApplicationBusyMouse(boolean busy) {
        setApplicationMouseCursor(busy ? "wait":"auto");
    }

    public static void setApplicationProgressMouse(boolean progress) {
        setApplicationMouseCursor(progress ? "progress":"auto");
    }

    private static void setApplicationMouseCursor(String cursor) {
        DOM.setStyleAttribute(RootPanel.getBodyElement(), "cursor", cursor);
    }

    public static native void disableSelection(Element element) /*-{
        element.onselectstart = function() {
            return false;
        };
        element.unselectable = "on";
        element.style.MozUserSelect = "none";
        element.style.cursor = "default";
    }-*/;

    public static void disableSelection() {
        disableSelection(RootPanel.getBodyElement());
    }

    /**
     * Disables browser's standard context menu for the given element.
     */
    public static native void disableContextMenu(Element element) /*-{
        element.oncontextmenu = function() {
            return false;
        }
    }-*/;

    public static void disableContextMenu() {
        disableContextMenu(RootPanel.getBodyElement());
    }

}
