/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

/**
 * Default implementation of the grid view. Singleton.
 *
 * @author Sergey Kozmin
 * @since 28.03.2007
 */
public class DefaultGridView implements GridView {
    public static final DefaultGridView INSTANCE = new DefaultGridView();

    private DefaultGridView() {
    }

    public String getActiveGridRowStyleName() {
        return "grid-ActiveRow";
    }

    public String getHeaderRowStyleName() {
        return "grid-HeaderRow";
    }

    public String getRowStyleName() {
        return "grid-Row";
    }

    public String getAlternativeRowStyleName() {
        return "grid-AlternativeRow";
    }

    public String getColumnResizeStyleName() {
        return "grid-ColumnResize";
    }

    public String getMainGridStyleName() {
        return "grid-Main";
    }

    public String getHighlightedGridRowStyleName() {
        return "grid-HighlightedRow";
    }

    public String getMSGridRowStyleName() {
        return "grid-MSRow";
    }

    public String getMouseOverRowStyleName() {
        return "grid-MouseOverRow";
    }

    public String getHeaderCellStyleName() {
        return "grid-HeaderCell";
    }

    public String getSelectedHeaderCellStyleName() {
        return "grid-HeaderCellSelected";
    }
}
