/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.common.ui.grid;

/**
 * Listen grid events
 *
 * @author Sergey Kozmin
 * @since 09.10.2006, 15:44:11
 */
public interface GridSelectionListener {
    /**
     * To be called when grid cell is selected
     *
     * @param row         cell row
     * @param column      cell column
     * @param keyModifier modifier, specified in {@link com.google.gwt.user.client.ui.KeyboardListener}
     */
    public void gridCellSelected(int row, int column, int keyModifier);

    /**
     * To be called when grid column is selected
     *
     * @param column the column
     */
    public void gridColumnSelected(int column);

    /**
     * To be called when user press a key
     *
     * @param keyCode           the key code
     * @param keyboardModifiers keyboard modifiers, specified in {@link com.google.gwt.user.client.ui.KeyboardListener}
     */
    public void onKeyDown(char keyCode, int keyboardModifiers);

    /**
     * To be called when user made mouse in or mouse out for the row
     *
     * @param row row index
     * @param in  was mouse in, or mouse out
     */
    public void mousePositionChanged(int row, boolean in);
}
