/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.common.ui.subsetselect;

import com.google.gwt.user.client.ui.Composite;
import com.queplix.core.client.app.vo.SubsetData;
import com.queplix.core.client.app.vo.SubsetMeta;

/**
 * Base class for subset selectors.
 *
 * @author Sultan Tezadov
 * @since 17 Nov 2006
 */
public abstract class AbstractSubsetSelect extends Composite {
    private SubsetMeta meta;
    private SubsetData data;

    public SubsetMeta getMeta() {
        if(meta == null) {
            meta = new SubsetMeta();
        }
        return meta;
    }

    public void setMeta(SubsetMeta meta) {
        if(meta == null) {
            throw new IllegalArgumentException(
                    "Argument 'meta' can not be null");
        }
        this.meta = meta;
        createWidgets();
    }

    public SubsetData getData() {
        if(data == null) {
            data = new SubsetData();
        }
        return data;
    }

    public void setData(SubsetData data) {
        if(data == null) {
            throw new IllegalArgumentException(
                    "Argument 'data' can not be null");
        }
        this.data = data;
        populateWidgets();
    }

    /**
     * Create widgets from meta
     */
    protected abstract void createWidgets();

    /**
     * Fill widgets with data
     */
    protected abstract void populateWidgets();
}
