package com.queplix.core.client.controls.charts;

import com.queplix.core.client.app.vo.ChartFieldData;
import com.queplix.core.client.app.vo.ChartFieldMeta;
import com.queplix.core.client.app.vo.ChartFieldOnDemandData;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

class QChartModelImpl extends QFormElementModelImpl
        implements QChartModel {
    
    public QChartModelImpl(ChartFieldMeta meta) {
        setMeta(meta);
        setData(new ChartFieldData(getMeta().getFieldID()));
    }

    public ChartFieldMeta getMeta() {
        if(getBaseMeta() == null) {
            setMeta(new ChartFieldMeta());
        }
        return (ChartFieldMeta) getBaseMeta();
    }

    public void setMeta(ChartFieldMeta meta) {
        setBaseMeta(meta);
    }
    
    public ChartFieldData getData() {
        if (getBaseData() == null) {
            setData(new ChartFieldData());
        }
        return (ChartFieldData) getBaseData();
    }
    
    public void setData(ChartFieldData data) {
        setBaseData(data);
    }
    
    public ChartFieldOnDemandData getOnDemandData() {
        return (ChartFieldOnDemandData) getFieldOnDemandData();
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel)
            throws DataCloneException {
        if(TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + TYPE + ", from " + sameTypeControlModel
                    .getDataType());
        }
        QChartModel model = (QChartModel) sameTypeControlModel;
        setData((ChartFieldData) model.getData().cloneData());
    }

    public int getDataType() {
        return TYPE;
    }

    public boolean isLinkable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

}
