/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.entitylink;

import com.google.gwt.user.client.ui.ClickListener;
import com.queplix.core.client.app.vo.EntityLinkFieldData;
import com.queplix.core.client.app.vo.EntityLinkOnDemandData;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.controls.QFormElement;

/**
 * @author alexander.epifanov
 */
public class QEntityLinkViewImpl extends QEntityLinkView {
    private static final ButtonData LINKED_STATE = new ButtonData(null,
            "Linked", "entitylink/entitylink_linked.gif");
    private static final ButtonData UN_LINKED_STATE = new ButtonData(null,
            "Un-linked", "entitylink/entitylink_unlinked.gif");
    private static final ButtonData BROKEN_STATE = new ButtonData(null,
            "Broken", "entitylink/entitylink_broken.gif");

    private IconButton showbutton;

    private QEntityLinkModelImpl model;

    public QEntityLinkViewImpl(QEntityLinkModelImpl model) {
        super(model, QFormElement.HORIZONTAL);
        this.model = model;
        initializeGUI();
    }

    public void onModelMetaChanged() {
        setCaption(model.getMeta().getCaption());
    }

    public void onModelDataChanged() {
        super.onModelDataChanged();
        checkEntityLinked();
    }

    public void onDemandModelChanged() {
        checkEntityLinked();
    }

    private void checkEntityLinked() {
        EntityLinkFieldData data = model.getData();
        EntityLinkOnDemandData onDemandData = model.getOnDemandData();
        if(onDemandData == null
                || onDemandData.getLinkedEntityID().equals(
                EntityLinkFieldData.EMPTY_VALUE)
                || data.getCurrentEntityID().equals(
                EntityLinkFieldData.EMPTY_VALUE)) {
            showbutton.setButtonState(BROKEN_STATE);
        } else {
            showbutton.setButtonState(data.getLinkedEntityIDs().contains(
                    onDemandData.getLinkedEntityID()) ? LINKED_STATE
                    :UN_LINKED_STATE);
        }
    }

    private void initializeGUI() {
        showbutton = new IconButton(BROKEN_STATE);
        showbutton.setStyleName(QEntityLink.ENTITYLINK_IMAGE_STYLE);
        addToPanel(showbutton);
        initPanel();
    }

    public void addActionListener(ClickListener listener) {
        showbutton.addClickListener(listener);
    }

    public void removeActionListener(ClickListener listener) {
        showbutton.removeClickListener(listener);
    }

    protected void setEnabled(boolean isEnabled) {
        showbutton.setEnabled(isEnabled);
    }

    protected void setClientWidth(String clientWidth) {
    }

    public int getClientWidth() {
        return 0;
    }
}
