/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.informgrid;

import com.queplix.core.client.app.vo.RecordFilter;

import java.util.List;

/**
 * Implements in-form search state
 *
 * @author Sergey Kozmin
 * @since 06.10.2006, 13:19:20
 */
class EditGridState extends AbstractState {
    private static final String SHOULD_SELECT_RECORD
            = "To link a record you need to select it in filtering dialog.";

    public EditGridState(StateContext context) {
        super(context, EDIT_STATE);
    }

    public void enterToState() {
        context.showLinkButtons();
        context.enableLinkButtons();
        context.hideFilterButton();
        updateLinkButtonsState();
    }

    public void actionPerformed(int action)
            throws IncorrectGridActionPerformed {
        switch(action) {
            case QInformGrid.CONTROL_STATE_CHANGED_INDEX: {
                handleControlStateChange();
                break;
            }
            case QInformGrid.RECORD_SELECTION_CHANGED_INDEX: {
                updateLinkButtonsState();
                break;
            }
            case QInformGrid.LINK_BUTTON_INDEX: {
                context.showFilteringDialog();
                updateLinkButtonsState();
                break;
            }
            case QInformGrid.UNLINK_BUTTON_INDEX: {
                context.removeRecords(context.getSelectedRecords());
                updateLinkButtonsState();
                break;
            }
            case QInformGrid.FILTERS_WERE_SET_INDEX: {
                RecordFilter filter = context.getDialogFilter();
                if(!filter.isRecordsFilter()) {
                    context.showMessage(SHOULD_SELECT_RECORD);
                } else {
                    context.addQFormElementFilter(filter);
                }
                break;
            }
            default: {
                throw new IncorrectGridActionPerformed(
                        "Internal error! Could not perform the action: "
                                + action + ", in edit state");
            }
        }
    }

    private void handleControlStateChange()
            throws IncorrectGridActionPerformed {
        changeStateIfAnother();
        /*
        int newState = getInternalState(context.getControlState());
        if(newState != getState()) {
            switch(newState) {
                case SEARCH_STATE: {//on form cancel
                    if (context.askQuestion(CLEAR_DATA_QUESTION)) {
                        *//*try {
                            context.changeState(QInformGridState.SELECTED_STATE);
                        } catch (IncorrectQFormElementData incorrectQFormElementData) {
                            DialogHelper.showModalMessageDialog("Error occured:" + incorrectQFormElementData.getMessage());
                        }*//*
                    }
                    break;
                }
                case SELECTED_STATE: {//on form update
                    context.changeState(newState);
                    break;
                }
                default: {
                    throw new IncorrectGridActionPerformed("Internal error! "
                            + "Could not handle the transfer from the state: "
                            + getState() + ", to: " + newState + " state.");
                }
            }
            context.changeState(newState);
        }
        */
    }

    private void updateLinkButtonsState() {
        List selectedRecords = context.getSelectedRecords();
        context.setEnabledUnLinkButton(selectedRecords.size() > 0);
    }
}
