/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.informgrid;

import com.queplix.core.client.app.vo.GridData;
import com.queplix.core.client.app.vo.GridMeta;
import com.queplix.core.client.app.vo.InFormGridFieldData;
import com.queplix.core.client.app.vo.InFormGridFieldMeta;
import com.queplix.core.client.app.vo.InFormGridOnDemandData;
import com.queplix.core.client.app.vo.SortFieldImpl;
import com.queplix.core.client.common.ui.grid.BaseGridModel;
import com.queplix.core.client.common.ui.grid.DataGridMeta;
import com.queplix.core.client.common.ui.grid.DataGridMetaImpl;
import com.queplix.core.client.common.ui.grid.TextGridDataProvider;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

class QInformGridModelImpl extends QFormElementModelImpl
        implements QInformGridModel {
    private DataGridMeta dataGridMeta;

    private InformGridModel gridModel;
    private TextGridDataProvider dataProvider;

    public QInformGridModelImpl(InFormGridFieldMeta meta) {
        gridModel = new InformGridModel();
        setMeta(meta);
        setData(new InFormGridFieldData(meta.getFieldID()));
    }

    public InFormGridFieldMeta getMeta() {
        if(null == super.getBaseMeta()) {
            setMeta(new InFormGridFieldMeta());
        }
        return (InFormGridFieldMeta) super.getBaseMeta();
    }

    public InFormGridFieldData getData() {
        return (InFormGridFieldData) super.getBaseData();
    }

    public InFormGridOnDemandData getOnDemandData() {
        return (InFormGridOnDemandData) super.getFieldOnDemandData();
    }

    private void setData(InFormGridFieldData data) {
        setBaseData(data);
        fireDataChanged();
    }

    private void initDataProvider(GridData data) {
        if(dataProvider != null) {
            dataProvider.setData(data);
        } else {
            dataProvider = new TextGridDataProvider(data);
            gridModel.setDataProvider(dataProvider);
        }
    }

    private void setMeta(InFormGridFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    protected void fireModelMetaChanged() {
        dataGridMeta = DataGridMetaImpl.createDataGridMeta(
                getMeta().getPresentationGridMeta());
        gridModel.fireDataStructureChanged();
        super.fireModelMetaChanged();
    }

    protected void fireModelDataChanged() {
        initDataProvider(getData().getGridData());
        gridModel.fireDataChanged();
        super.fireModelDataChanged();
    }

    public boolean isValid() {
        return true;
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel)
            throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel
                    .getDataType());
        }
        setData((InFormGridFieldData) sameTypeControlModel.getBaseData()
                .cloneData());
    }

    public void fireDataChanged() {
        fireModelDataChanged();
    }

    public boolean isLinkable() {
        return true;
    }

    public InformGridModel getGridModel() {
        return gridModel;
    }

    public SortFieldImpl getSortFieldImpl(){
        return gridModel.getSortFieldImpl();
    }

    private class InformGridModel extends BaseGridModel {
        protected GridData getData() {
            return QInformGridModelImpl.this.getData().getGridData();
        }

        protected GridMeta getMeta() {
            return QInformGridModelImpl.this.getMeta()
                    .getPresentationGridMeta();
        }

        public DataGridMeta getDataGridMeta() {
            return dataGridMeta;
        }
    }
}