/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe;

import com.queplix.core.client.frames.QFrame;
import com.queplix.core.client.app.vo.MetaData;

/**
 * This interface must be implemented by any mainframe implementation.
 * Here should be included all the methods, that are needed for only core
 * functionality but not for the concrete applications.
 *
 * @author Sergey Kozmin
 * @since 10.04.2007
 */
public interface IMainFrame extends QFrame {
    /**
     * Initialize mainframe with operations factory.
     * This method should be called before any business action occured.
     *
     * @param appMetaData application metadata to initialize view
     * @param factory factory object
     * @param viewPropertiesProvider properties provider
     */
    public void initMainFrame(MetaData appMetaData, StrategiesFactory factory,
                              ViewPropertiesProvider viewPropertiesProvider);

}
