/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames.mainframe.impl;

/**
 * Encapsulate form event data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 14:11:54
 */
abstract class FormEvent {
    public static final int SEARCH_EVENT = 0;
    public static final int NEW_EVENT = 1;
    public static final int UPDATE_EVENT = 2;
    public static final int CLEAR_EVENT = 3;
    public static final int CHANGE_EVENT = 4;
    public static final int MENU_EVENT = 5;

    /**
     * one of the form event (listed above).
     */
    private int eventID;

    public FormEvent(int eventID) {
        this.eventID = eventID;
    }

    public int getEventID() {
        return eventID;
    }
}
