/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.LabelButtonSet;

/**
 * Last viewed records list.
 *
 * @author Alexander Melnik
 * @since 3 Nov 2006
 */
class LastViewed extends LabelButtonSet {
    private static int HISTORY_SIZE = 20;

    public LastViewed() {
        super(false);
    }

    /**
     * pkey - record ID
     */
    public void addHistoryItem(FamgMeta.Index index, String formCaption,
                               Long recordId, String description) {
        addHistoryItem(new GridHistoryRecord(index, formCaption, recordId,
                description));
    }

    public void addHistoryItem(GridHistoryRecord record) {
        for(int i=0; i<getButtonsCount(); i++) {
           GridHistoryRecord curRec = (GridHistoryRecord) getEvent(i)
                    .getData();
            if(isEqual(curRec, record)) {
                removeButton(i);
                break;
            }
        }
        
        if(getButtonsCount() >= HISTORY_SIZE) {
            removeButton(HISTORY_SIZE - 1);
        }
        String tmp = record.getDescription() == null ? String.valueOf(
                record.getRecordId().toString()):record.getDescription();
        addButton(new Event(record), new ButtonData(
                record.getFormCaption() + " : " + tmp), false);
    }

    private boolean isEqual(GridHistoryRecord record0,
                            GridHistoryRecord record1) {
        return record0.equals(record1) || (record0.getFormCaption().equals(
                record1.getFormCaption()) &&
                record0.getRecordId().equals(record1.getRecordId()));
    }
}
