/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.google.gwt.user.client.ui.Label;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.FrameLinks;
import com.queplix.core.client.frames.mainframe.MainFrameLinkEvents;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * Frame Links. Throws events described in {@link com.queplix.core.client.frames.mainframe.MainFrameLinkEvents}
 *
 * @author Sultan Tezadov
 * @since 26 Nov 2006
 */
class MainFrameLinks extends FrameLinks {
    private static interface Buttons {
        ButtonData HELP = new ButtonData("Help");
        ButtonData ABOUT = new ButtonData("About");
        ButtonData MY_SETTINGS = new ButtonData("My Settings");
        ButtonData REPORT_DESIGNER = new ButtonData("Ad-Hoc Report");
        ButtonData LOGOUT = new ButtonData("Logout");
    }

    private static final String MY_QUEUE_NAME = "inbox";
    private Event myQueueEvent;
    
    public MainFrameLinks(MetaData appMetaData) {
        createCustomButtons(appMetaData);
        createStaticButtons();
    }

    private void createStaticButtons() {
        Buttons.HELP.setCaptionStyle("linkIconButton");
        addButton(MainFrameLinkEvents.HELP, Buttons.HELP);
        Buttons.ABOUT.setCaptionStyle("linkIconButton");
        addButton(MainFrameLinkEvents.ABOUT, Buttons.ABOUT);
// This is not garbage code, just temporarily commented out. Do not remove
//        Buttons.MY_SETTINGS.setCaptionStyle("linkIconButton");
//        addButton(Events.MY_SETTINGS, Buttons.MY_SETTINGS);
        Buttons.REPORT_DESIGNER.setCaptionStyle("linkIconButton");
        addButton(MainFrameLinkEvents.REPORT_DESIGNER, Buttons.REPORT_DESIGNER);
        Buttons.LOGOUT.setCaptionStyle("linkIconButton");
        addButton(MainFrameLinkEvents.LOGOUT, Buttons.LOGOUT);
    }

    private void createCustomButtons(MetaData appMetaData) {
        ArrayList al = appMetaData.getAllTabMetas();
        Iterator it = al.iterator();
        while(it.hasNext()) {
            TabMeta tabMeta = (TabMeta) it.next();
            if(tabMeta.isInFrameLinks()) {
                Event event = new Event(tabMeta.getIndex());
                ButtonData button = new ButtonData(tabMeta.getCaption());
                button.setCaptionStyle("linkIconButton");
                addButton(event, button);
                if (tabMeta.getTabName().equalsIgnoreCase(MY_QUEUE_NAME)) {
                    myQueueEvent = event;
                }
            }
        }
    }

    public void onEvent(Event event) {
        Object eventData = event.getData();
        if(eventData instanceof TabMeta.Index) { // custom button
            event = MainFrameSA.Events.TAB_SELECTED;
            event.setData(eventData);
        }
        super.onEvent(event);
    }
    
    public void setMailStatus(boolean hasUnreadMessages) {
        Label label = getLabelByEvent(myQueueEvent);
        if (label != null) {
            label.setStyleName(hasUnreadMessages ? "markedLinkIconButton" :
                               "linkIconButton");
        }
    }

}
