/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

/*
 * ShortCuts.java
 *
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.ContextMenuMeta;
import com.queplix.core.client.app.vo.MenuItemMeta;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.LabelButtonSet;

/**
 * Class represent regeneratable shortcuts panel with ability to send events with the given parameters.
 *
 * @author aliaksandr.melnik, Sergey Kozmin
 */
class ShortCuts extends LabelButtonSet {
    public ShortCuts() {
        super(false);
    }

    public void reGenerateShortCuts(ContextMenuMeta contextMenuMeta) {
        removeAllButtons();
        MenuItemMeta[] menuItems;
        if(contextMenuMeta != null) {
            menuItems = contextMenuMeta.getMenuItems();
            if(menuItems != null) {
                for(int i = 0; i < menuItems.length; i++) {
                    Event event = new Event(menuItems[i].getMenuItemID());
                    ButtonData data = new ButtonData(menuItems[i].getCaption());
                    addButton(event, data);
                }
            }
        }
    }
}
