/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.modules.config;

import com.queplix.core.jxb.entity.Entity;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocal;
import com.queplix.core.modules.config.ejb.EntityViewConfigManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.www.AbstractServlet;
import com.queplix.core.utils.www.ServletHelper;
import com.queplix.core.utils.xml.XMLHelper;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Entity View Config Servlet.
 * <strong>USAGE</strong>: <pre>GET /sys/entity?name=employee</pre>
 * <p><strong>Parameters</strong>:
 * name: the Entity name
 * </p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2005/09/06 06:52:59 $
 */

public class EntityViewConfigServlet
        extends AbstractServlet {

    //
    // Service method
    //
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        String entityName = ServletHelper.getParamAsString(request, "name",
                true);
        logger.DEBUG("Get entity '" + entityName + "'...");

        EntityViewConfigManagerLocal local = (EntityViewConfigManagerLocal)
                getLocalObject(JNDINames.EntityViewConfigManager,
                        EntityViewConfigManagerLocalHome.class);

        Entity entity = local.getEntityViewConfig(entityName);

        // Deserialize response
        XMLHelper.writeObject(entity, response.getWriter());
    }

}
