/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.www;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>Basic filter, that reads configuration into array</p>
 *
 * @author [DAG] Dmitry Gaponenko
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:24 $
 */

public abstract class ParametrizedFilter
        extends AbstractFilter {

    private Object[] params;
    private int paramsNum;

    /**
     * Initialize filter
     *
     * @param filterConfig HTTP filter config
     * @throws ServletException
     */
    public void init(FilterConfig filterConfig)
            throws ServletException {

        HashMap paramsMap = new HashMap();
        for(Enumeration e = filterConfig.getInitParameterNames();
            e.hasMoreElements();) {
            String name = (String) e.nextElement();
            String value = filterConfig.getInitParameter(name);
            paramsMap.put(name, value);
        }
        paramsNum = paramsMap.size();
        params = paramsMap.entrySet().toArray();
    }

    /**
     * Do filter
     *
     * @param request  HTTP request
     * @param response HTTP response
     * @param chain    FilterChain object
     * @throws IOException
     * @throws ServletException
     */
    public void doFilter(ServletRequest request,
                         ServletResponse response,
                         FilterChain chain)
            throws IOException, ServletException {

        for(int j = 0; j < paramsNum; j++) {
            Map.Entry entry = (Map.Entry) params[j];
            String paramName = (String) entry.getKey();
            String paramValue = (String) entry.getValue();

            if(doFilterParam(request, response, chain, paramName, paramValue)) {
                return;
            }
        }
        chain.doFilter(request, response);
    }

    /**
     * Destroy filter
     */
    public void destroy() {
        super.destroy();
        params = null;
    }

    /**
     * Abstract method wich performs filter params
     *
     * @param request    HTTP request
     * @param response   HTTP response
     * @param chain      FilterChain object
     * @param paramName  param name
     * @param paramValue param value
     * @return <code>true</code> if procedure fail
     * @throws IOException
     * @throws ServletException
     */
    public abstract boolean doFilterParam(ServletRequest request,
                                          ServletResponse response,
                                          FilterChain chain,
                                          String paramName,
                                          String paramValue)
            throws IOException, ServletException;
}
