package com.queplix.tools.fkchecker.kernel.types;

/**
 * This class encapsulates info about one point of foreign key.
 * @author dmitry.antonov
 */
public class KeyPair {

    private final String tableName;
    private final String columnName;

    public KeyPair(String tableName, String columnName) {
        this.tableName = tableName.toUpperCase();
        this.columnName = columnName.toUpperCase();
    }

    public int hashCode() {
        return tableName.hashCode() + columnName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyPair) {
            KeyPair kp = (KeyPair) obj;
            return tableName.equals(kp.tableName) && columnName.equals(kp.columnName);
        }
        else {
            return false;
        }
    }

    public String toString() {
        return "[" + tableName + "." + columnName + "]";
    }


}
