<?xml version="1.0" encoding="UTF-8"?>
<!--
  ~ Copyright 2006-2007 Queplix Corp.
  ~
  ~ Licensed under the Queplix Public License, Version 1.1.1 (the "License");
  ~ you may not use this file except in compliance with the License.
  ~ You may obtain a copy of the License at
  ~
  ~ http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
  ~ License for the specific language governing permissions and limitations under
  ~ the License.
  ~
  -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <project name="init" default="init" basedir=".">
            <target name="init">
                <xsl:text disable-output-escaping="yes">
                <![CDATA[
                <delete dir="${application.dist-dir}"/>
                ]]>
                </xsl:text>
                <xsl:apply-templates/>
            </target>
        </project>
    </xsl:template>

    <xsl:template match="module-location">
        <xsl:text disable-output-escaping="yes">&lt;var name="qmodule.dir" value="${application.dir}/</xsl:text>
        <xsl:value-of select='@dir'/>
        <xsl:text disable-output-escaping="yes">"/&gt;</xsl:text>

        <xsl:text disable-output-escaping="yes">&lt;var name="qmodule.name" value="</xsl:text>
        <xsl:value-of select='@name'/>
        <xsl:text disable-output-escaping="yes">"/&gt;</xsl:text>

        <xsl:text disable-output-escaping="yes">
        <![CDATA[
        <delete dir="${qmodule.dir}/qmodule-build"/>

        <var name="qmodule.ejb.id" value="${qmodule.name}-ejb"/>
        <var name="qmodule.ejb-dist.dir" value="${qmodule.dir}/${qmodule.ejb.id}/dist"/>
        <var name="qmodule.ejb-build.dir" value="${qmodule.dir}/${qmodule.ejb.id}/build/ear-module"/>
        <var name="qmodule.ejb-jar-file" value="${qmodule.ejb-build.dir}/META-INF/ejb-jar.xml"/>

        <var name="qmodule.ejb-temp.dir" value="${qmodule.dir}/${qmodule.ejb.id}/build/tmp"/>
        <mkdir dir="${qmodule.ejb-temp.dir}/META-INF"/>
        <copy file="${qmodule.ejb-jar-file}" toFile="${qmodule.ejb-temp.dir}/META-INF/ejb-jar.xml" overwrite="true" failonerror="false"/>
        ]]>
        </xsl:text>
    </xsl:template>
</xsl:stylesheet>