/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.gen;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

import java.util.List;

/**
 * <p/>
 * Ticket Notification JEO handler
 * </p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.7 $ $Date: 2005/09/02 16:32:09 $
 */
public class TicketNotificationObjectHandler extends JEObjectHandler {

    public String getEntityName() {
        return "notification";
    }

    public Class getObjectClass() {
        return TicketNotificationObject.class;
    }

    // Select by ID
    public static JEObjectHandler selectByPkey(JEOManagerLocal local,
                                               LogonSession ls, long pkey)
            throws EQLException {
        String eql =
                "SELECT notification.* WHERE notification.qw_notificationid = "
                        + pkey;
        List hndList = local.select(ls, TicketNotificationObjectHandler.class,
                eql);
        if(hndList == null) {
            return null;
        } else {
            return (JEObjectHandler) hndList.get(0);
        }

    }

    // Select by Ticket Data (product and customer)
    public static List selectByTicketData(JEOManagerLocal local,
                                          LogonSession ls,
                                          Long ticketProduct,
                                          Long ticketCustomer,
                                          boolean isIntCustomer)
            throws EQLException {

        if(ticketProduct == null && ticketCustomer == null) {
            return null;
        }
        StringBuffer eql = new StringBuffer();

        eql.append("SELECT notification.* WHERE ");
        eql.append("(");

        boolean andClause = false;

        if(ticketProduct != null) {
            andClause = true;
            eql.append("(");
            eql.append("notification.qw_productid IS NULL").append(
                    " OR ");
            eql.append("notification.qw_productid = ").append(
                    ticketProduct);
            eql.append(")");
        }

        if(ticketCustomer != null) {
            if(andClause) {
                eql.append(" AND ");
            }
            andClause = true;
            eql.append("");
            eql.append("(notification.qw_organizationid IS NULL)").append(
                    " OR ");
            eql.append("(notification.qw_organizationid IN ");
            if(isIntCustomer) {
                eql.append(
                        "(SELECT employee.qw_orgid WHERE employee.qw_employeeid = ")
                        .append(ticketCustomer).append(")");
            } else {
                eql.append(
                        "(SELECT customer.qw_orgid WHERE customer.qw_customerid = ")
                        .append(ticketCustomer).append(")");
            }
            eql.append(")");
        }
        eql.append(")");

        return local.select(ls, TicketNotificationObjectHandler.class,
                eql.toString());
    }
}
