/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.update;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.qwoss.gen.AttachmentObjectsObject;
import com.queplix.qwoss.gen.AttachmentObjectsObjectHandler;
import com.queplix.qwoss.utils.ApplicationHelper;

/**
 * Attachment with linked ticket update script.
 *
 * @author Sergei Savchuk
 */
public class AttachmentTicketUpdate extends EntityUpdate {

    public static final String ATTACHMENT_ID = "attachment_id";
    public static final String TICKET_ID = "qw_ticketid";
    public static final String ATTACHMENT_OBJECTS_TABLE
            = "QX_ATTACHMENT_OBJECTS";

    public void afterUpdate() throws EQLException {
        if(isNew()) {
            // Initialization.
            JEOManagerLocal jeoManager = (JEOManagerLocal)
                    getCOM().getLocalObject(JNDINames.JEOManager,
                            JEOManagerLocalHome.class);
            LogonSession ls = getEUO().getSession().getLogonSession();

            Long ticketId = getCell(TICKET_ID).getLong();
            Long attachId = getCell(ATTACHMENT_ID).getLong();
            if(ticketId != null) {
                JEObjectHandler linkHnd = jeoManager.create(ls,
                        AttachmentObjectsObjectHandler.class);
                AttachmentObjectsObject linkObj
                        = (AttachmentObjectsObject) linkHnd.getJEObject();
                linkObj.setAttachment_id(attachId);
                linkObj.setObject_id(ticketId);
                linkObj.setObject_type(ApplicationHelper.TICKET_OBJECT_TYPE);
                jeoManager.commit(linkHnd);
            }
        }
    }
}
