/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.update;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.UserAuthenticationType;
import com.queplix.core.modules.eql.EQLResCell;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.UserObject;
import com.queplix.core.modules.jeo.gen.UserObjectHandler;
import com.queplix.core.modules.jeo.gen.UserSettingsObject;
import com.queplix.core.modules.jeo.gen.UserSettingsObjectHandler;
import com.queplix.core.utils.JNDINames;

/**
 * Employees update business logic.
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:51 $
 */
public class EmployeeUpdate
        extends EntityUpdate {

    /* (non-Javadoc)
     * @see EntityUpdate#beforeUpdate()
     */
    public int beforeUpdate() throws EQLException {

        long time = System.currentTimeMillis();
        INFO("Before update script started...");

        // Initialization.
        LogonSession ls = getLogonSession();
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().
                getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);

        EQLResCell firstNameCell = getCell("qw_firstname");
        EQLResCell lastNameCell = getCell("qw_lastname");
        EQLResCell fullNameCell = getCell("qw_fullname");
        EQLResCell loginNameCell = getCell("qw_loginname");
        EQLResCell emailCell = getCell("qw_email");
        EQLResCell userIdCell = getCell("qw_userid");
        String firstName = firstNameCell.getString();
        String lastName = lastNameCell.getString();
        String login = loginNameCell.getString();
        String email = emailCell.getString();
        long userId;
        String fullName = lastName + ", " + firstName;
        fullNameCell.setString(fullName);

        UserObjectHandler userHnd = (UserObjectHandler)
                UserObjectHandler.selectByLogin(jeoManager, ls, login);
        if(isNew()) {
            if(userHnd != null) {
                throw new EQLException("User ID already in database: " + login);
            } else {
                // User handler and object 
                JEObjectHandler hnd = jeoManager.create(ls,
                        UserObjectHandler.class);
                UserObject userObj = (UserObject) hnd.getJEObject();
                userObj.setLoginname(login);
                userObj.setFullname(fullName);
                userObj.setEmail(email);
                userObj.setUser_type(UserAuthenticationType.DB_LOGIN_TYPE);
                jeoManager.commit(hnd);
                userId = userObj.getPkey().longValue();
                userIdCell.setNumber(userId);
            }
            // User Settings
            JEObjectHandler hndSet = jeoManager.create(ls,
                    UserSettingsObjectHandler.class);
            UserSettingsObject userSetObj = (UserSettingsObject) hndSet
                    .getJEObject();
            userSetObj.setUser_id(userId, false);
            jeoManager.commit(hndSet);
        } else {
            userId = userIdCell.getLong().longValue();
            if(userHnd != null) {
                UserObject userObj = (UserObject) userHnd.getJEObject();
                if(userId != userObj.getPkey()) {
                    throw new EQLException(
                            "User ID already in database: " + login);
                } else {
                    userObj.setFullname(fullName);
                    userObj.setEmail(email);
                    jeoManager.commit(userHnd);
                }
            } else {
                // Find UserObject object.
                UserObjectHandler hnd = (UserObjectHandler)
                        UserObjectHandler.selectHandlerByID(jeoManager, ls,
                                userId);
                UserObject userObj = (UserObject) hnd.getJEObject();
                userObj.setLoginname(login);
                userObj.setFullname(fullName);
                userObj.setEmail(email);
                jeoManager.commit(hnd);
            }
        }

        // Ok.
        INFO("Completed, time (ms) = " + (System.currentTimeMillis() - time));
        return CONTINUE;
    }
}
