/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.update;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.qwoss.gen.EscRecipientFieldObject;
import com.queplix.qwoss.gen.EscRecipientFieldObjectHandler;
import com.queplix.qwoss.gen.TicketEscalationObject;
import com.queplix.qwoss.gen.TicketEscalationObjectHandler;
import com.queplix.qwoss.utils.TicketEscalationHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * Description.
 *
 * @author rustem.nizamiev
 */

public class TicketEscalationUpdate extends EntityUpdate {

    /*
     * (non-Javadoc)
     * 
     * @see EntityUpdate#beforeUpdate()
     */
    public int beforeUpdate() throws EQLException {

        // Initialization.
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().
                getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);
        // Get current record.
        JEObjectHandler hnd = getJEOHandler(jeoManager, TicketEscalationObjectHandler.class);
        TicketEscalationObject obj = (TicketEscalationObject) hnd.getJEObject();
        // Initialize delete candidates list
        ArrayList<Long> deleteCandidates = new ArrayList<Long>();
        // Check recipient
        List escRecipientHandlers = obj.dsQw_recipient(EscRecipientFieldObjectHandler.class);
        // for all recipients do --
        if(escRecipientHandlers != null) {
            for(int j = 0; j < escRecipientHandlers.size(); j++) {
                EscRecipientFieldObjectHandler escRecipientFieldObjectHandler =
                        (EscRecipientFieldObjectHandler) escRecipientHandlers.get(j);
                EscRecipientFieldObject escRecipientFieldObject =
                        (EscRecipientFieldObject) escRecipientFieldObjectHandler.getJEObject();
                Long escRecipientPKey = escRecipientFieldObject.getQw_id();
                if(deleteCandidates.contains(escRecipientPKey)) 
                    continue;
                if(escRecipientFieldObjectHandler.getEqlResRecord().doDelete()){
                    deleteCandidates.add(escRecipientPKey);
                    continue;
                }
                Integer recipinet = escRecipientFieldObject.getQw_recipient();
                if(recipinet == null) {
                    throw new EQLException("Recipient is needed.");
                }
                switch(recipinet.intValue()) {
                    case TicketEscalationHelper.ASSIGNED_WORKGROUP_RECIPIENT:
                        if(obj.getQw_workgroupid() == null) {
                            throw new EQLException("Please specify workgroup for workgroup recipient.");
                        }
                        break;
                    case TicketEscalationHelper.ASSIGNED_EMPLOYEE_RECIPIENT:
                        if(obj.getQw_employeeid() == null) {
                            throw new EQLException("Please specify employee for employee recipient.");
                        }
                        if(obj.getQw_sendmode() == null) {
                            throw new EQLException("Please supply a notification method in 'Then Send' field");
                        }
                        break;
                    case TicketEscalationHelper.ASSIGNED_EMAIL_RECIPIENT:
                        if(obj.getQw_email() == null || obj.getQw_email().trim().length() < 1) {
                            throw new EQLException("Please specify email address.");
                        }
                        break;
                }
            }
        }
        return CONTINUE;
    }
}
